/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;

class Transaction {
    boolean isDelete;
    Table tTable;
    Row row;
    long SCN;

    Transaction(boolean bl, Table table, Row row, long l) {
        this.isDelete = bl;
        this.tTable = table;
        this.row = row;
    }

    void rollback(Session session, boolean bl) {
        try {
            if (this.isDelete) {
                this.tTable.insertNoCheckRollback(session, this.row, bl);
            } else {
                this.tTable.deleteNoCheckRollback(session, this.row, bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void commit(Session session) {
        try {
            if (this.isDelete) {
                this.tTable.removeRowFromStore(this.row);
            } else {
                this.tTable.commitRowToStore(this.row);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void logRollback(Session session) {
        try {
            if (this.isDelete) {
                this.tTable.database.logger.writeInsertStatement(session, this.tTable, this.row.getData());
            } else {
                this.tTable.database.logger.writeDeleteStatement(session, this.tTable, this.row.getData());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void logAction(Session session) {
        try {
            if (this.isDelete) {
                this.tTable.database.logger.writeDeleteStatement(session, this.tTable, this.row.getData());
            } else {
                this.tTable.database.logger.writeInsertStatement(session, this.tTable, this.row.getData());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

