"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypedError = void 0;
let getStackTrace;
if (Error.captureStackTrace != null) {
    const captureStackTrace = Error.captureStackTrace;
    getStackTrace = (e) => {
        captureStackTrace(e, e.constructor);
    };
}
else {
    getStackTrace = (e, err) => {
        if (!(err instanceof Error)) {
            err = new Error(err);
        }
        if (err.stack != null) {
            e.stack = err.stack;
        }
    };
}
class TypedError extends Error {
    constructor(err = '') {
        super();
        this.stack = '';
        if (err instanceof Error) {
            this.message = err.message;
        }
        else {
            this.message = err;
        }
        Object.setPrototypeOf(this, new.target.prototype);
        this.name = this.constructor.name;
        getStackTrace(this, err);
    }
}
exports.TypedError = TypedError;
//# sourceMappingURL=typed-error.js.map