/**
 * @license
 * Copyright 2019 Balena Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/// <reference types="node" />
import { Transform } from 'stream';
import { BlockMap } from './blockmap';
import { ReadRange } from './read-range';
export declare class FilterStream extends Transform {
    readonly blockMap: BlockMap;
    readonly verify: boolean;
    readonly generateChecksums: boolean;
    readonly chunkSize: number;
    /** Number of block map ranges read */
    rangesRead: number;
    /** Number of block map ranges verified */
    rangesVerified: number;
    /** Number of blocks read */
    blocksRead: number;
    /** Number of bytes read */
    bytesRead: number;
    /** Number of bytes written */
    blocksWritten: number;
    /** Number of bytes written */
    bytesWritten: number;
    /** Current offset in bytes */
    position: number;
    /** @type {Array<Object>} Ranges */
    ranges: ReadRange[];
    /** Range being currently processed */
    currentRange?: ReadRange;
    /** Hash stream to calculate range checksums */
    private _hash?;
    private _chunks;
    private _bytes;
    constructor(blockMap: BlockMap, verify?: boolean, generateChecksums?: boolean, chunkSize?: number);
    /**
     * Preprocess the `blockMap`'s ranges into byte-ranges
     * with respect to the `start` offset, and an `offset`
     * for tracking chunked range reading
     */
    private _getByteRangesFromBlockMap;
    /**
     * Verify a fully read range's checksum against
     * the range's checksum from the blockmap
     * or calculate the range's checksum and update the blockmap
     * if options.generateChecksums is true.
     */
    private _verifyRange;
    /**
     * Determine whether a chunk is in the current range
     */
    private _rangeInChunk;
    /**
     * Chunk a given input buffer into blocks
     * matching the blockSize and advance the
     * current range, if necessary
     */
    private _transformBlock;
    /** Transform input into block-sized chunks */
    _transform(chunk: Buffer, _encoding: string, next: () => void): void;
    /**
     * Flush out any unprocessed chunks from
     * the internal buffer once the stream is being ended
     */
    _flush(done: () => void): void;
}
