/// <reference types="node" />
import { Readable } from 'stream';
import { BLOCK } from './constants';
import { Image } from './image';
export declare function withOpenImage<T>(filePath: string, fn: (image: Image) => Promise<T>): Promise<T>;
export declare function blockGenerator(image: Image, exclude?: BLOCK[]): Generator<{
    entry: import("./image").InternalEntry;
    block: import("./block").Block;
}, void, unknown>;
export declare function blockDecompressor(type: BLOCK, inputStream: NodeJS.ReadableStream): NodeJS.ReadableStream;
export declare class ZeroStream extends Readable {
    private length;
    private blank;
    constructor(length?: number, blank?: Buffer);
    _read(): void;
}
export declare function streamToBuffer(stream: NodeJS.ReadableStream): Promise<Buffer>;
