/// <reference types="node" />
import { EventEmitter } from 'events';
export declare const isUsbBootCapableUSBDevice: (idVendor: number, idProduct: number) => boolean;
export declare abstract class UsbbootDevice extends EventEmitter {
    portId: string;
    abstract readonly LAST_STEP: number;
    private _step;
    last_serial: number;
    constructor(portId: string);
    get progress(): number;
    get step(): number;
    set step(step: number);
}
export declare class CM3 extends UsbbootDevice {
    readonly LAST_STEP = 40;
}
export declare class CM4 extends UsbbootDevice {
    readonly LAST_STEP = 10;
}
export declare class UsbbootScanner extends EventEmitter {
    private usbbootDevices;
    private boundAttachDevice;
    private boundDetachDevice;
    private interval;
    private attachedDeviceIds;
    private extraFolder;
    constructor(extraFolder?: string);
    start(): void;
    stop(): void;
    private step;
    private get;
    private getOrCreate;
    private remove;
    private attachDevice;
    private detachDevice;
    private fileServer;
}
