/// <reference types="node" />
import { promises as fs } from 'fs';
import { Readable, Transform } from 'stream';
import { BufferDiskChunk, DiscardDiskChunk, DiskChunk } from './diskchunk';
import { Interval } from './interval-intersection';
import { Range } from './mapped-ranges';
export { BufferDiskChunk, DiscardDiskChunk, DiskChunk, Interval, Range };
export interface ReadResult {
    bytesRead: number;
    buffer: Buffer;
}
export interface WriteResult {
    bytesWritten: number;
    buffer: Buffer;
}
export declare class DiskStream extends Readable {
    private readonly disk;
    private readonly capacity;
    private position;
    private isReading;
    constructor(disk: Disk, capacity: number, highWaterMark: number, position: number);
    private __read;
    _read(size: number): void;
}
export declare function withOpenFile<T>(path: string, flags: string | number, fn: (handle: fs.FileHandle) => Promise<T>): Promise<T>;
export declare abstract class Disk {
    readOnly: boolean;
    recordWrites: boolean;
    recordReads: boolean;
    discardIsZero: boolean;
    readonly knownChunks: DiskChunk[];
    capacity: number | null;
    constructor(readOnly?: boolean, recordWrites?: boolean, recordReads?: boolean, discardIsZero?: boolean);
    protected abstract _getCapacity(): Promise<number>;
    protected abstract _read(buffer: Buffer, bufferOffset: number, length: number, fileOffset: number): Promise<ReadResult>;
    protected abstract _write(buffer: Buffer, bufferOffset: number, length: number, fileOffset: number): Promise<WriteResult>;
    protected abstract _flush(): Promise<void>;
    getTransformStream(): Transform;
    read(buffer: Buffer, _bufferOffset: number, length: number, fileOffset: number): Promise<ReadResult>;
    write(buffer: Buffer, bufferOffset: number, length: number, fileOffset: number): Promise<WriteResult>;
    flush(): Promise<void>;
    discard(offset: number, length: number): Promise<void>;
    getCapacity(): Promise<number>;
    getStream(position?: number, length?: number | null, highWaterMark?: number): Promise<DiskStream>;
    getDiscardedChunks(): DiskChunk[];
    getRanges(blockSize: number): Promise<Range[]>;
    private insertDiskChunk;
    private createReadPlan;
    private readAccordingToPlan;
}
export declare class FileDisk extends Disk {
    protected readonly handle: fs.FileHandle;
    constructor(handle: fs.FileHandle, readOnly?: boolean, recordWrites?: boolean, recordReads?: boolean, discardIsZero?: boolean);
    protected _getCapacity(): Promise<number>;
    protected _read(buffer: Buffer, bufferOffset: number, length: number, fileOffset: number): Promise<ReadResult>;
    protected _write(buffer: Buffer, bufferOffset: number, length: number, fileOffset: number): Promise<WriteResult>;
    protected _flush(): Promise<void>;
}
export declare class BufferDisk extends Disk {
    private readonly buffer;
    constructor(buffer: Buffer, readOnly?: boolean, recordWrites?: boolean, recordReads?: boolean, discardIsZero?: boolean);
    protected _getCapacity(): Promise<number>;
    protected _read(buffer: Buffer, bufferOffset: number, length: number, fileOffset: number): Promise<ReadResult>;
    protected _write(buffer: Buffer, bufferOffset: number, length: number, fileOffset: number): Promise<WriteResult>;
    protected _flush(): Promise<void>;
}
