/**
 * @license
 * Copyright 2019 Balena Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/// <reference types="node" />
import { Range } from './range';
export interface BlockMapOptionsRange {
    start: number;
    end: number;
    checksum: string;
}
export interface BlockMapOptions {
    /** @type {String} format version */
    version?: string;
    /** @type {Number} size of the image in bytes */
    imageSize?: number;
    /** @type {Number} size of a block in bytes */
    blockSize?: number;
    /** @type {Number} total number of blocks in image */
    blocksCount?: number;
    /** @type {Number} number of mapped blocks */
    mappedBlocksCount?: number;
    /** @type {String} bmap file checksum */
    checksum?: string;
    /** @type {Number} checksum algorithm */
    checksumType?: string;
    /** @type {Number} block ranges */
    ranges?: BlockMapOptionsRange[];
}
export declare class BlockMap {
    /** Supported .bmap format versions */
    static versions: string[];
    version?: string;
    imageSize: number;
    blockSize: number;
    blocksCount: number;
    mappedBlocksCount: number;
    checksum?: string;
    checksumType: string;
    ranges: Range[];
    constructor(options?: BlockMapOptions);
    /**
     * Calculate the bmap file's checksum and inject it
     */
    private injectChecksum;
    /** Create a block map from its JSON representation */
    static fromJSON(data: string | unknown): BlockMap;
    /** Stringify a block map into .bmap format */
    toString(): string;
    /** Parse a .bmap file */
    static parse(value: string | Buffer, verify?: boolean): BlockMap;
}
