"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sparseReadStream = void 0;
const constants_1 = require("./constants");
const utils_1 = require("./utils");
const EXCLUDE = [
    // Don't read comments or block map terminators
    constants_1.BLOCK.COMMENT,
    constants_1.BLOCK.TERMINATOR,
    // Ignore free, since this is a sparse stream
    constants_1.BLOCK.FREE,
];
async function* sparseReadStream(image) {
    for (const { entry, block } of (0, utils_1.blockGenerator)(image, EXCLUDE)) {
        let position = entry.map.sectorNumber * constants_1.SECTOR_SIZE + block.sectorNumber * constants_1.SECTOR_SIZE;
        if (block.type === constants_1.BLOCK.ZEROFILL) {
            const size = block.sectorCount * constants_1.SECTOR_SIZE;
            for await (const buffer of new utils_1.ZeroStream(size)) {
                yield { buffer, position };
                position += buffer.length;
            }
        }
        else {
            const offset = image.footer.dataForkOffset + block.compressedOffset;
            const length = block.compressedLength;
            const inputStream = await image.fs.createReadStream(offset, offset + length - 1);
            const stream = (0, utils_1.blockDecompressor)(block.type, inputStream);
            for await (const buffer of stream) {
                yield { buffer, position };
                position += buffer.length;
            }
        }
    }
}
exports.sparseReadStream = sparseReadStream;
//# sourceMappingURL=sparse-readstream.js.map