/// <reference types="node" />
import { BlockMap } from './blockmap';
import { Footer } from './footer';
interface InternalBlk {
    id: number;
    attributes: number;
    name: string;
    data: Buffer;
}
export declare type InternalEntry = Omit<InternalBlk, 'data'> & {
    map: BlockMap;
    coreFoundationName: string;
};
interface InternalResourceFork {
    blkx: InternalEntry[];
    nsiz: InternalBlk[];
    cSum: Array<Omit<InternalBlk, 'data'> & {
        data: {
            unknown: number;
            type: number;
            value: string;
        };
    }>;
    plst: InternalBlk[];
    size: InternalBlk[];
}
interface Fs {
    size: number;
    createReadStream: (start?: number, end?: number) => Promise<NodeJS.ReadableStream>;
}
/**
 * Apple Disk Image (DMG)
 */
export declare class Image {
    readonly fs: Fs;
    footer?: Footer;
    resourceFork: InternalResourceFork;
    readonly ready: Promise<void>;
    constructor(fs: Fs);
    private open;
    private static parseBlkx;
    private static parseNsiz;
    private static parsePlst;
    private static parseCsum;
    private static parseSize;
    /** Create a readable stream of this image */
    createReadStream(end?: number): Promise<any>;
    /** Create a sparse readable stream of this image */
    createSparseReadStream(): Promise<any>;
    /** Calculate the uncompressed size of the contained resource */
    getUncompressedSize(): Promise<number>;
    /** Calculate the amount of mapped (non-zero & non-free) bytes */
    getMappedSize(): Promise<number>;
    verifyData(): Promise<boolean | null>;
    private readFooter;
    private readPropertyList;
}
export {};
