"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedLocales = exports.langParser = void 0;
const i18next = __importStar(require("i18next"));
const react_i18next_1 = require("react-i18next");
const zh_CN_1 = __importDefault(require("./i18n/zh-CN"));
const zh_TW_1 = __importDefault(require("./i18n/zh-TW"));
const en_1 = __importDefault(require("./i18n/en"));
function langParser() {
    if (process.env.LANG !== undefined) {
        // Bypass mocha, where lang-detect don't works
        return 'en';
    }
    const lang = Intl.DateTimeFormat().resolvedOptions().locale;
    switch (lang.substr(0, 2)) {
        case 'zh':
            if (lang === 'zh-CN' || lang === 'zh-SG') {
                return 'zh-CN';
            } // Simplified Chinese
            else {
                return 'zh-TW';
            } // Traditional Chinese
        default:
            return lang.substr(0, 2);
    }
}
exports.langParser = langParser;
i18next.use(react_i18next_1.initReactI18next).init({
    lng: langParser(),
    fallbackLng: 'en',
    nonExplicitSupportedLngs: true,
    interpolation: {
        escapeValue: false,
    },
    resources: {
        'zh-CN': zh_CN_1.default,
        'zh-TW': zh_TW_1.default,
        en: en_1.default,
    },
});
exports.supportedLocales = ['en', 'zh'];
exports.default = i18next;
