"use strict";
/**
 * @license
 * Copyright 2019 Balena Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.withOpenFile = void 0;
const tslib_1 = require("tslib");
const fs = require("fs");
function open(filename) {
    return new Promise((resolve, reject) => {
        fs.open(filename, 'r', (error, fd) => {
            if (error) {
                reject(error);
            }
            else {
                resolve(fd);
            }
        });
    });
}
function close(fd) {
    return new Promise((resolve, reject) => {
        fs.close(fd, (error) => {
            if (error) {
                reject(error);
            }
            else {
                resolve();
            }
        });
    });
}
function withOpenFile(filename, fn) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const fd = yield open(filename);
        try {
            yield fn(fd);
        }
        finally {
            yield close(fd);
        }
    });
}
exports.withOpenFile = withOpenFile;
//# sourceMappingURL=utils.js.map