/// <reference types="node" />
import { Checksum } from './checksum';
/**
 * UDIF Footer (aka Koly Block)
 */
export declare class Footer {
    /** Koly block structure size in bytes */
    static readonly SIZE = 512;
    /** Magic 32-bit value; 'koly' in ASCII */
    static readonly SIGNATURE = 1802464377;
    /** UDIF Version (latest known == 4) */
    static readonly VERSION = 4;
    /** Signature */
    signature: number;
    /** Version number */
    version: number;
    /** Size of this structure in bytes */
    headerSize: number;
    /** Flags */
    flags: number;
    /** Running data fork offset (?) */
    runningDataForkOffset: number;
    /** Data fork offset */
    dataForkOffset: number;
    /** Data fork length in bytes */
    dataForkLength: number;
    /** Resource fork offset */
    resourceForkOffset: number;
    /** Resource fork length in bytes */
    resourceForkLength: number;
    /** Segment number */
    segmentNumber: number;
    /** Segment count */
    segmentCount: number;
    /** Segment ID */
    segmentId: Buffer;
    /** Data checksum */
    dataChecksum: Checksum;
    /** XML data offset */
    xmlOffset: number;
    /** XML data length in bytes */
    xmlLength: number;
    /** Reserved 1 */
    reserved1: Buffer;
    /** Checksum */
    checksum: Checksum;
    /** Image variant */
    imageVariant: number;
    /** Sector count */
    sectorCount: number;
    /** Reseved 2 */
    reserved2: number;
    /** Reseved 3 */
    reserved3: number;
    /** Reseved 4 */
    reserved4: number;
    /** Parse a Koly block from a buffer */
    static parse(buffer: Buffer, offset?: number): Footer;
    /** Parse a Koly block from a buffer */
    parse(buffer: Buffer, offset?: number): this;
    /**
     * Write a Koly block to a buffer
     */
    write(buffer?: Buffer, offset?: number): Buffer;
}
