"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const _1 = require("./");
const main = () => {
    const scanner = new _1.UsbBBbootScanner();
    scanner.on('attach', (usbBBbootDevice) => {
        console.log('device attached', usbBBbootDevice.portId);
        usbBBbootDevice.on('progress', (progress) => {
            console.log('progress', usbBBbootDevice.portId, progress, '%');
            if (progress === 100) {
                console.log('device', usbBBbootDevice.portId, 'is ready');
            }
        });
    });
    scanner.on('detach', (usbBBbootDevice) => {
        console.log('device', usbBBbootDevice.portId, 'detached');
    });
    console.log('Waiting for BeagleBone');
    try {
        scanner.start();
    }
    catch (err) {
        console.log(err);
    }
};
main();
//# sourceMappingURL=main.js.map