"use strict";
/** Get metadata for a source */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSourceMetadata = void 0;
const etcher_sdk_1 = require("etcher-sdk");
const windows_network_drives_1 = require("../gui/app/os/windows-network-drives");
const axios_1 = __importDefault(require("axios"));
const utils_1 = require("../shared/utils");
const path = __importStar(require("path"));
const lodash_1 = require("lodash");
function isString(value) {
    return typeof value === 'string';
}
async function createSource(selected, SourceType, auth) {
    try {
        selected = await (0, windows_network_drives_1.replaceWindowsNetworkDriveLetter)(selected);
    }
    catch (error) {
        // TODO: analytics.logException(error);
    }
    if ((0, utils_1.isJson)(decodeURIComponent(selected))) {
        const config = JSON.parse(decodeURIComponent(selected));
        return new etcher_sdk_1.sourceDestination.Http({
            url: config.url,
            axiosInstance: axios_1.default.create((0, lodash_1.omit)(config, ['url'])),
        });
    }
    if (SourceType === 'File') {
        return new etcher_sdk_1.sourceDestination.File({
            path: selected,
        });
    }
    return new etcher_sdk_1.sourceDestination.Http({ url: selected, auth });
}
async function getMetadata(source, selected) {
    const metadata = (await source.getMetadata());
    const partitionTable = await source.getPartitionTable();
    if (partitionTable) {
        metadata.hasMBR = true;
        metadata.partitions = partitionTable.partitions;
    }
    else {
        metadata.hasMBR = false;
    }
    if (isString(selected)) {
        metadata.extension = path.extname(selected).slice(1);
        metadata.path = selected;
    }
    return metadata;
}
async function getSourceMetadata(selected, SourceType, auth) {
    // `Record<string, never>` means an empty object
    if (isString(selected)) {
        const source = await createSource(selected, SourceType, auth);
        try {
            const innerSource = await source.getInnerSource();
            const metadata = await getMetadata(innerSource, selected);
            return metadata;
        }
        catch (error) {
            // TODO: handle error
            return {};
        }
        finally {
            await source.close();
        }
    }
    else {
        return {};
    }
}
exports.getSourceMetadata = getSourceMetadata;
