"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readStream = void 0;
const constants_1 = require("./constants");
const utils_1 = require("./utils");
// Don't read comments or block map terminators
const EXCLUDE = [constants_1.BLOCK.COMMENT, constants_1.BLOCK.TERMINATOR];
async function* readStream(image, end) {
    // end is inclusive
    let remaining = end + 1;
    for (const { block } of (0, utils_1.blockGenerator)(image, EXCLUDE)) {
        if (remaining <= 0) {
            return;
        }
        if (block.type === constants_1.BLOCK.ZEROFILL || block.type === constants_1.BLOCK.FREE) {
            const size = Math.min(block.sectorCount * constants_1.SECTOR_SIZE, remaining);
            yield* new utils_1.ZeroStream(size);
            remaining -= size;
        }
        else {
            const offset = image.footer.dataForkOffset + block.compressedOffset;
            const length = block.compressedLength;
            const inputStream = await image.fs.createReadStream(offset, offset + length - 1);
            for await (let chunk of (0, utils_1.blockDecompressor)(block.type, inputStream)) {
                if (chunk.length > remaining) {
                    chunk = chunk.slice(0, remaining);
                }
                yield chunk;
                remaining -= chunk.length;
            }
        }
    }
}
exports.readStream = readStream;
//# sourceMappingURL=readstream.js.map