"use strict";
/* tslint:disable */
Object.defineProperty(exports, "__esModule", { value: true });
exports.TFTP = void 0;
const util_1 = require("./util");
const sp = require('schemapack');
// TFTP packet --- this is only for ACK packets
const tftp = sp.build([
    { opcode: 'uint16' },
    { blk_number: 'uint16' },
    { pad: 'string' },
]);
// TFTP ERROR packet
const tftp_error = sp.build([
    { opcode: 'uint16' },
    { err_code: 'uint16' },
    { err_mesg: 'string' },
    { pad: 'string' },
]);
class TFTP {
    // Function for TFTP packet --- this is only for ACK packets
    makeTFTP(opcode, blk_number) {
        const tftp_data = [{ opcode: opcode }, { blk_number: blk_number }];
        return (0, util_1.fixBuff)(tftp.encode(tftp_data));
    }
    // Function for TFTP error packet
    makeTFTPError(opcode, err_code, desc) {
        const my_tftp_error = [
            { opcode: opcode },
            { err_code: err_code },
            { err_msg: desc },
        ];
        return (0, util_1.fixBuff)(tftp_error.encode(my_tftp_error));
    }
}
exports.TFTP = TFTP;
//# sourceMappingURL=tftp.js.map