"use strict";
/*
 * Copyright 2016 balena.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.error = exports.warning = exports.compatibility = exports.info = exports.progress = void 0;
const outdent_1 = require("outdent");
const pretty_bytes_1 = __importDefault(require("pretty-bytes"));
require("../gui/app/i18n");
const i18next = __importStar(require("i18next"));
exports.progress = {
    successful: (quantity) => {
        return i18next.t('message.flashSucceed', { count: quantity });
    },
    failed: (quantity) => {
        return i18next.t('message.flashFail', { count: quantity });
    },
};
exports.info = {
    flashComplete: (imageBasename, [drive], { failed, successful }) => {
        const targets = [];
        if (failed + successful === 1) {
            targets.push(i18next.t('message.toDrive', {
                description: drive.description,
                name: drive.displayName,
            }));
        }
        else {
            if (successful) {
                targets.push(i18next.t('message.toTarget', {
                    count: successful,
                    num: successful,
                }));
            }
            if (failed) {
                targets.push(i18next.t('message.andFailTarget', { count: failed, num: failed }));
            }
        }
        return i18next.t('message.succeedTo', {
            name: imageBasename,
            target: targets.join(' '),
        });
    },
};
exports.compatibility = {
    sizeNotRecommended: () => {
        return i18next.t('message.sizeNotRecommended');
    },
    tooSmall: () => {
        return i18next.t('message.tooSmall');
    },
    locked: () => {
        return i18next.t('message.locked');
    },
    system: () => {
        return i18next.t('message.system');
    },
    containsImage: () => {
        return i18next.t('message.containsImage');
    },
    // The drive is large and therefore likely not a medium you want to write to.
    largeDrive: () => {
        return i18next.t('message.largeDrive');
    },
};
exports.warning = {
    tooSmall: (source, target) => {
        return (0, outdent_1.outdent)({ newline: ' ' }) `
			 ${i18next.t('message.sourceLarger', {
            byte: (0, pretty_bytes_1.default)(source.size - target.size),
        })}
		`;
    },
    exitWhileFlashing: () => {
        return i18next.t('message.exitWhileFlashing');
    },
    looksLikeWindowsImage: () => {
        return i18next.t('message.looksLikeWindowsImage');
    },
    missingPartitionTable: () => {
        return i18next.t('message.missingPartitionTable', {
            type: i18next.t('message.image'),
        });
    },
    driveMissingPartitionTable: () => {
        return i18next.t('message.missingPartitionTable', {
            type: i18next.t('message.drive'),
        });
    },
    largeDriveSize: () => {
        return i18next.t('message.largeDriveSize');
    },
    systemDrive: () => {
        return i18next.t('message.systemDrive');
    },
    sourceDrive: () => {
        return i18next.t('message.sourceDrive');
    },
};
exports.error = {
    notEnoughSpaceInDrive: () => {
        return i18next.t('message.noSpace');
    },
    genericFlashError: (err) => {
        return i18next.t('message.genericFlashError', { error: err.message });
    },
    validation: () => {
        return i18next.t('message.validation');
    },
    openSource: (sourceName, errorMessage) => {
        return i18next.t('message.openError', {
            source: sourceName,
            error: errorMessage,
        });
    },
    flashFailure: (imageBasename, drives) => {
        const target = drives.length === 1
            ? i18next.t('message.toDrive', {
                description: drives[0].description,
                name: drives[0].displayName,
            })
            : i18next.t('message.toTarget', {
                count: drives.length,
                num: drives.length,
            });
        return i18next.t('message.flashError', {
            image: imageBasename,
            targets: target,
        });
    },
    driveUnplugged: () => {
        return i18next.t('message.unplug');
    },
    inputOutput: () => {
        return i18next.t('message.cannotWrite');
    },
    childWriterDied: () => {
        return i18next.t('message.childWriterDied');
    },
    unsupportedProtocol: () => {
        return i18next.t('message.badProtocol');
    },
};
