"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Encoder = exports.Parser = void 0;
const arp_1 = require("./arp");
const bootp_1 = require("./bootp");
const eth_1 = require("./eth");
const ip_1 = require("./ip");
const rndis_1 = require("./rndis");
const tftp_1 = require("./tftp");
const udp_1 = require("./udp");
class Parser {
    // ether header
    parseEthHdr(buff) {
        return new eth_1.Eth().parseEthHdr(buff);
    }
    // IPV4 header
    parseIpv4(buff) {
        return new ip_1.IP().parseIpv4(buff);
    }
    // IPV6 header
    parseIpv6(buff) {
        return new ip_1.IP().parseIpv6(buff);
    }
    parseIpv6Option(buff) {
        return new ip_1.IP().parseIpv6Option(buff);
    }
    // UDP packet
    parseUdp(buff) {
        return new udp_1.UDP().parseUdp(buff);
    }
    parseBOOTP(buff) {
        return new bootp_1.BOOTP().parseBOOTP(buff);
    }
    parseARP(buff) {
        return new arp_1.ARP().parseARP(buff);
    }
}
exports.Parser = Parser;
// tslint:disable-next-line
class Encoder {
    // Make RNDIS
    makeRNDIS(dataLength) {
        return new rndis_1.RNDIS().makeRNDIS(dataLength);
    }
    makeRNDISInit() {
        return new rndis_1.RNDIS().makeRNDISInit();
    }
    makeRNDISSet() {
        return new rndis_1.RNDIS().makeRNDISSet();
    }
    makeEther2(dest, source, proto) {
        return new eth_1.Eth().makeEther2(dest, source, proto);
    }
    makeIPV4(srcAddr, dstAddr, proto, id, totalLen, chksum) {
        return new ip_1.IP().makeIPV4(srcAddr, dstAddr, proto, id, totalLen, chksum);
    }
    makeUDP(udpDataLen, srcPort, dstPort) {
        return new udp_1.UDP().makeUDP(udpDataLen, srcPort, dstPort);
    }
    makeBOOTP(serverName, fileName, xid, hwDest, bbIP, serverIP) {
        return new bootp_1.BOOTP().makeBOOTP(serverName, fileName, xid, hwDest, bbIP, serverIP);
    }
    makeARP(opCode, hwSource, ipSource, hwDest, ipDest) {
        return new arp_1.ARP().makeARP(opCode, hwSource, ipSource, hwDest, ipDest);
    }
    makeTFTP(opcode, blkNumber) {
        return new tftp_1.TFTP().makeTFTP(opcode, blkNumber);
    }
    makeTFTPError(opcode, errCode, desc) {
        return new tftp_1.TFTP().makeTFTPError(opcode, errCode, desc);
    }
}
exports.Encoder = Encoder;
//# sourceMappingURL=index.js.map