"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BLOCK = exports.CHECKSUM_TYPE = exports.SECTOR_SIZE = void 0;
/**
 * Size of a sector in bytes
 * NOTE: Beware, as this is just a guess based on
 * the sector numbers and their contents in images
 */
exports.SECTOR_SIZE = 512;
/** Checksum types */
var CHECKSUM_TYPE;
(function (CHECKSUM_TYPE) {
    CHECKSUM_TYPE[CHECKSUM_TYPE["NONE"] = 0] = "NONE";
    CHECKSUM_TYPE[CHECKSUM_TYPE["CRC32"] = 2] = "CRC32";
    // There are more (MD5, etc.), but
    // I haven't found out their values, yet
})(CHECKSUM_TYPE = exports.CHECKSUM_TYPE || (exports.CHECKSUM_TYPE = {}));
/** Mish Data BLKX types */
var BLOCK;
(function (BLOCK) {
    BLOCK[BLOCK["ZEROFILL"] = 0] = "ZEROFILL";
    BLOCK[BLOCK["RAW"] = 1] = "RAW";
    // NOTE: Since "Apple_Free" regions are marked with this,
    // and some region's intermittent blocks have it, this is probably "UNALLOCATED"
    BLOCK[BLOCK["FREE"] = 2] = "FREE";
    BLOCK[BLOCK["UDCO"] = 2147483652] = "UDCO";
    BLOCK[BLOCK["UDZO"] = 2147483653] = "UDZO";
    BLOCK[BLOCK["UDBZ"] = 2147483654] = "UDBZ";
    BLOCK[BLOCK["LZFSE"] = 2147483655] = "LZFSE";
    BLOCK[BLOCK["COMMENT"] = 2147483646] = "COMMENT";
    BLOCK[BLOCK["TERMINATOR"] = 4294967295] = "TERMINATOR";
})(BLOCK = exports.BLOCK || (exports.BLOCK = {}));
//# sourceMappingURL=constants.js.map