"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.safeReadFile = exports.stringToAscii = exports.fixBuff = void 0;
const fs_1 = require("fs");
const Path = require("path");
///////////////////////////////////////// Function to remove extra byte from last /////////////////////////////////
const fixBuff = (buff) => {
    const bufFix = Buffer.alloc(buff.length - 1, 0, 'hex');
    buff.copy(bufFix, 0, 0, buff.length - 1);
    return bufFix;
};
exports.fixBuff = fixBuff;
const stringToAscii = (filename) => {
    let x = 0;
    const fileName = [];
    while (x <= 72) {
        x = fileName.push(x < filename.length ? filename.charCodeAt(x) : 0);
    }
    return fileName;
};
exports.stringToAscii = stringToAscii;
const safeReadFile = (filename) => {
    try {
        const filePath = Path.join(__dirname, '..', '..', '..', 'blobs', 'am335x', filename);
        return (0, fs_1.readFileSync)(filePath);
    }
    catch (e) {
        // no data
        return undefined;
    }
};
exports.safeReadFile = safeReadFile;
//# sourceMappingURL=util.js.map