"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const simpleCredentialsProvider_1 = require("./simpleCredentialsProvider");
it("returns undefined for not provided credentials", () => __awaiter(void 0, void 0, void 0, function* () {
    const provider = new simpleCredentialsProvider_1.SimpleCredentialsProvider();
    const credentials = yield provider.getCredentials();
    expect(credentials).toBeUndefined();
}));
it("returns credentials for provided credentials", () => __awaiter(void 0, void 0, void 0, function* () {
    const provider = new simpleCredentialsProvider_1.SimpleCredentialsProvider({
        accessKeyId: "MOCK_ACCESS_KEY_ID",
        secretAccessKey: "MOCK_SECRET_ACCESS_KEY",
        sessionToken: "MOCK_SESSION_TOKEN",
    });
    const credentials = yield provider.getCredentials();
    expect(credentials).toStrictEqual({
        accessKeyId: "MOCK_ACCESS_KEY_ID",
        secretAccessKey: "MOCK_SECRET_ACCESS_KEY",
        sessionToken: "MOCK_SESSION_TOKEN",
    });
}));
