"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const client_cloudformation_1 = require("@aws-sdk/client-cloudformation");
const region = process.env.AWS_REGION || "eu-west-2";
module.exports = () => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    const stackName = `AWSv4AxiosInfraStack`;
    const cf = new client_cloudformation_1.CloudFormationClient({ region });
    const stacks = yield cf.send(new client_cloudformation_1.DescribeStacksCommand({
        StackName: stackName,
    }));
    const stack = (_a = stacks.Stacks) === null || _a === void 0 ? void 0 : _a[0];
    if (stack === undefined) {
        throw new Error(`Couldn't find CloudFormation stack with name ${stackName}`);
    }
    process.env.API_GATEWAY_URL = (_d = (_c = (_b = stack.Outputs) === null || _b === void 0 ? void 0 : _b.find((o) => o.OutputKey === "HttpApiUrl")) === null || _c === void 0 ? void 0 : _c.OutputValue) === null || _d === void 0 ? void 0 : _d.replace(/\/$/, "");
    process.env.CLIENT_ROLE_ARN = (_f = (_e = stack.Outputs) === null || _e === void 0 ? void 0 : _e.find((o) => o.OutputKey === "ClientRoleArn")) === null || _f === void 0 ? void 0 : _f.OutputValue;
    process.env.ASSUMED_CLIENT_ROLE_ARN = (_h = (_g = stack.Outputs) === null || _g === void 0 ? void 0 : _g.find((o) => o.OutputKey === "AssumedClientRoleArn")) === null || _h === void 0 ? void 0 : _h.OutputValue;
    process.env.AWS_REGION = region;
});
