import type { FileDisk } from 'file-disk';
import type { GetPartitionsResult } from 'partitioninfo';
/**
 * Summarizes the partition found by findPartition().
 */
export type FindPartitionResult = {
    index: number;
    /** partition name for GPT, or filesystem label for MBR */
    name: string;
};
/**
 * @summary Find the partition on the provided disk with a name that matches one
 * of the provided names.
 *
 * Matches on partition name for GPT partitions or on filesystem label for MBR
 * partitions.
 *
 * @returns A FindPartitionResult with the found index and name/label; otherwise
 * undefined
 */
export declare function findPartition(fileDisk: FileDisk, partitionInfo: GetPartitionsResult, names: string[]): Promise<FindPartitionResult | undefined>;
