"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAuthErrorMessage = void 0;
const axios_1 = __importDefault(require("axios"));
/**
 * Utility method for extracting the error message from an API gateway 403
 *
 * @param error The error thrown by Axios
 */
const getAuthErrorMessage = (error) => {
    if (axios_1.default.isAxiosError(error)) {
        const data = error.response && error.response.data;
        if (data) {
            return data.message;
        }
    }
};
exports.getAuthErrorMessage = getAuthErrorMessage;
