"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const translation = {
    translation: {
        continue: '繼續',
        ok: '好',
        cancel: '取消',
        skip: '跳過',
        sure: '我確定',
        warning: '請注意！',
        attention: '請注意',
        failed: '失敗',
        completed: '完成',
        yesContinue: '是的，繼續',
        reallyExit: '真的要現在結束 Etcher 嗎？',
        yesExit: '是的，可以結束',
        progress: {
            starting: '正在啟動……',
            decompressing: '正在解壓縮……',
            flashing: '正在燒錄……',
            finishing: '正在結束……',
            verifying: '正在驗證……',
            failing: '失敗……',
        },
        message: {
            sizeNotRecommended: '大小不建議',
            tooSmall: '空間太小',
            locked: '被鎖定',
            system: '系統',
            containsImage: '存放來源映像檔',
            largeDrive: '很大的磁碟',
            sourceLarger: '所選的映像檔比目標磁碟大了 {{byte}} 位元組。',
            flashSucceed_one: '燒錄成功',
            flashSucceed_other: '燒錄成功',
            flashFail_one: '燒錄失敗',
            flashFail_other: '燒錄失敗',
            toDrive: '到 {{description}} ({{name}})',
            toTarget_one: '到 {{num}} 個目標',
            toTarget_other: '到 {{num}} 個目標',
            andFailTarget_one: '並燒錄失敗了 {{num}} 個目標',
            andFailTarget_other: '並燒錄失敗了 {{num}} 個目標',
            succeedTo: '{{name}} 被成功燒錄 {{target}}',
            exitWhileFlashing: '您目前正在刷寫。關閉 Etcher 可能會導致您的磁碟無法使用。',
            looksLikeWindowsImage: '看起來您正在嘗試燒錄 Windows 映像檔。\n\n與其他映像檔不同，Windows 映像檔需要特殊處理才能使其可啟動。我們建議您使用專門為此目的設計的工具，例如 <a href="https://rufus.akeo.ie">Rufus</a> (Windows)、<a href="https://github. com/slacka/WoeUSB">WoeUSB</a> (Linux) 或 Boot Camp 助理 (macOS)。',
            image: '映像檔',
            drive: '磁碟',
            missingPartitionTable: '看起來這不是一個可啟動的{{type}}。\n\n這個{{type}}似乎不包含分割表，因此您的設備可能無法識別或無法正確啟動。',
            largeDriveSize: '這是個很大容量的磁碟！請檢查並確認它不包含對您來說存放很重要的資料',
            systemDrive: '選擇系統分割區很危險，因為這將會刪除你的系統',
            sourceDrive: '來源映像檔位於這個分割區中',
            noSpace: '磁碟空間不足。請插入另一個較大的磁碟並重試。',
            genericFlashError: '出了點問題。如果來源映像檔曾被壓縮過，請檢查它是否已損壞。\n{{error}}',
            validation: '寫入已成功完成，但 Etcher 在從磁碟讀取映像檔時檢測到潛在的損壞問題。\n\n請考慮將映像檔寫入其他磁碟。',
            openError: '打開 {{source}} 時發生錯誤。\n\n錯誤訊息： {{error}}',
            flashError: '燒錄 {{image}} {{targets}} 失敗。',
            unplug: '看起來 Etcher 失去了對磁碟的連接。是不是被意外拔掉了？\n\n有時這個錯誤是因為讀卡器出了故障。',
            cannotWrite: '看起來 Etcher 無法寫入磁碟的這個位置。此錯誤通常是由故障的磁碟、讀取器或連接埠引起的。\n\n請使用其他磁碟、讀卡器或連接埠重試。',
            childWriterDied: '寫入處理程序意外崩潰。請再試一次，如果問題仍然存在，請聯絡 Etcher 團隊。',
            badProtocol: '僅支援 http:// 和 https:// 開頭的網址。',
        },
        target: {
            selectTarget: '選擇目標磁碟',
            plugTarget: '請插入目標磁碟',
            targets: '個目標',
            change: '更改',
        },
        source: {
            useSourceURL: '使用映像檔網址',
            auth: '驗證',
            username: '輸入使用者名稱',
            password: '輸入密碼',
            unsupportedProtocol: '不支持的通訊協定',
            windowsImage: '這可能是 Windows 系統映像檔',
            partitionTable: '找不到分割表',
            errorOpen: '打開來源映像檔時出錯',
            fromFile: '從檔案燒錄',
            fromURL: '從網址燒錄',
            clone: '再製磁碟',
            image: '映像檔訊息',
            name: '名稱：',
            path: '路徑：',
            selectSource: '選擇來源',
            plugSource: '請插入來源磁碟',
            osImages: '系統映像檔格式',
            allFiles: '任何檔案格式',
            enterValidURL: '請輸入正確的網址',
        },
        drives: {
            name: '名稱',
            size: '大小',
            location: '位置',
            find: '找到 {{length}} 個',
            select: '選取 {{select}}',
            showHidden: '顯示 {{num}} 個隱藏的磁碟',
            systemDriveDanger: '選擇系統分割區很危險，因為這將會刪除你的系統！',
            openInBrowser: 'Etcher 會在瀏覽器中打開 {{link}}',
            changeTarget: '更改目標',
            largeDriveWarning: '您即將格式化一個非常大的磁碟',
            largeDriveWarningMsg: '您確定所選磁碟不是儲存資料的磁碟嗎？',
            systemDriveWarning: '您將要格式化系統分割區',
            systemDriveWarningMsg: '您確定要燒錄到系統分割區嗎？',
        },
        flash: {
            another: '燒錄另一目標',
            target: '目標',
            location: '位置',
            error: '錯誤',
            flash: '燒錄',
            flashNow: '現在燒錄！',
            skip: '跳過了驗證',
            moreInfo: '更多資訊',
            speedTip: '透過將映像檔大小除以燒錄時間來計算速度。\n由於我們能夠跳過未使用的部分，因此具有 ext 分割區的磁碟映像檔燒錄速度更快。',
            speed: '速度：{{speed}} MB/秒',
            speedShort: '{{speed}} MB/秒',
            eta: '預計還需要：{{eta}}',
            failedTarget: '目標燒錄失敗',
            failedRetry: '重試燒錄失敗的目標',
            flashFailed: '燒錄失敗。',
            flashCompleted: '燒錄成功！',
        },
        settings: {
            errorReporting: '匿名向 balena.io 回報程式錯誤和使用統計資料',
            autoUpdate: '自動更新',
            settings: '軟體設定',
            systemInformation: '系統資訊',
            trimExtPartitions: '修改原始映像檔上未分配的空間（在 ext 類型分割區中）',
        },
        menu: {
            edit: '編輯',
            view: '預覽',
            devTool: '打開開發者工具',
            window: '視窗',
            help: '協助',
            pro: 'Etcher 專業版',
            website: 'Etcher 的官網',
            issue: '提交 issue',
            about: '關於 Etcher',
            hide: '隱藏 Etcher',
            hideOthers: '隱藏其它視窗',
            unhide: '取消隱藏',
            quit: '結束 Etcher',
        },
    },
};
exports.default = translation;
