import * as Fs from 'fs';
import { Disk } from 'file-disk';
export { getFsLabel, LabelNotFound } from './fsLabel';
export { findPartition, FindPartitionResult } from './utils';
/**
 * @summary Run a function with a node fs like interface for a partition
 *
 * @example
 *
 * const contents = await interact('/foo/bar.img', 5, async (fs) => {
 * 	return await promisify(fs.readFile)('/bar/qux');
 * });
 * console.log(contents);
 *
 */
export declare function interact<T>(disk: Disk | string, partition: number | undefined, fn: (fs: typeof Fs) => Promise<T>): Promise<T>;
