"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mockSend = void 0;
const assumeRoleCredentialsProvider_1 = require("./assumeRoleCredentialsProvider");
const client_sts_1 = require("@aws-sdk/client-sts");
jest.mock("@aws-sdk/client-sts");
let mockSTSSend;
const oneHourMs = 1000 * 60 * 60;
beforeAll(() => {
    process.env.AWS_REGION = "eu-central-1";
    jest.useFakeTimers();
});
afterAll(() => {
    jest.useRealTimers();
});
beforeEach(() => {
    mockSTSSend = (0, exports.mockSend)(client_sts_1.STSClient);
    mockSTSSend.mockImplementation((command) => {
        if (command instanceof client_sts_1.AssumeRoleCommand) {
            const expiration = new Date();
            expiration.setHours(expiration.getHours() + 1);
            return {
                Credentials: {
                    AccessKeyId: "MOCK_ACCESS_KEY_ID",
                    SecretAccessKey: "MOCK_SECRET_ACCESS_KEY",
                    SessionToken: "MOCK_SESSION_TOKEN",
                    Expiration: expiration,
                },
            };
        }
    });
});
it("returns credentials from assumed role", () => __awaiter(void 0, void 0, void 0, function* () {
    const provider = new assumeRoleCredentialsProvider_1.AssumeRoleCredentialsProvider({
        roleArn: "arn:aws:iam::111111111111:role/MockRole",
        region: "eu-west-1",
    });
    const credentials = yield provider.getCredentials();
    expect(credentials).toStrictEqual({
        accessKeyId: "MOCK_ACCESS_KEY_ID",
        secretAccessKey: "MOCK_SECRET_ACCESS_KEY",
        sessionToken: "MOCK_SESSION_TOKEN",
    });
}));
it("uses provided region", () => __awaiter(void 0, void 0, void 0, function* () {
    new assumeRoleCredentialsProvider_1.AssumeRoleCredentialsProvider({
        roleArn: "arn:aws:iam::111111111111:role/MockRole",
        region: "eu-west-1",
    });
    expect(client_sts_1.STSClient).toBeCalledWith({ region: "eu-west-1" });
}));
it("uses region from env if not provided", () => __awaiter(void 0, void 0, void 0, function* () {
    new assumeRoleCredentialsProvider_1.AssumeRoleCredentialsProvider({
        roleArn: "arn:aws:iam::111111111111:role/MockRole",
    });
    expect(client_sts_1.STSClient).toBeCalledWith({ region: "eu-central-1" });
}));
it("does not assume role again with active credentials", () => __awaiter(void 0, void 0, void 0, function* () {
    const provider = new assumeRoleCredentialsProvider_1.AssumeRoleCredentialsProvider({
        roleArn: "arn:aws:iam::111111111111:role/MockRole",
    });
    yield provider.getCredentials();
    yield provider.getCredentials();
    expect(mockSTSSend).toBeCalledTimes(1);
}));
it("assumes role again when credentials expired", () => __awaiter(void 0, void 0, void 0, function* () {
    const provider = new assumeRoleCredentialsProvider_1.AssumeRoleCredentialsProvider({
        roleArn: "arn:aws:iam::111111111111:role/MockRole",
        expirationMarginSec: 5,
    });
    yield provider.getCredentials();
    jest.advanceTimersByTime(oneHourMs);
    yield provider.getCredentials();
    expect(mockSTSSend).toBeCalledTimes(2);
}));
it("assumes role again in credentials expiration margin", () => __awaiter(void 0, void 0, void 0, function* () {
    const provider = new assumeRoleCredentialsProvider_1.AssumeRoleCredentialsProvider({
        roleArn: "arn:aws:iam::111111111111:role/MockRole",
        expirationMarginSec: 15,
    });
    yield provider.getCredentials();
    jest.advanceTimersByTime(oneHourMs - 1000 * 10);
    yield provider.getCredentials();
    expect(mockSTSSend).toBeCalledTimes(2);
}));
const mockSend = (client) => {
    const mock = jest.fn();
    client.mockImplementation(() => ({
        send: mock,
    }));
    return mock;
};
exports.mockSend = mockSend;
