"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const axios_1 = __importDefault(require("axios"));
const nock_1 = __importDefault(require("nock"));
const _1 = __importDefault(require("."));
describe("axios interceptor", () => {
    beforeAll(() => {
        nock_1.default.disableNetConnect();
    });
    beforeEach(() => {
        nock_1.default.cleanAll();
    });
    afterAll(() => {
        nock_1.default.enableNetConnect();
    });
    it("should not mutate request config object", () => __awaiter(void 0, void 0, void 0, function* () {
        // Arrange
        const client = axios_1.default.create();
        client.interceptors.request.use((0, _1.default)({ options: { region: "local" }, instance: axios_1.default }));
        const url = "http://localhost/foo";
        const config = {
            headers: { "X-Custom-Header": "foo", "Content-Type": "application/json" },
            params: { foo: "bar" },
        };
        // setup nock to return a
        (0, nock_1.default)(url).get("").query(config.params).reply(200, {});
        // Act
        yield client.get(url, config);
        // Assert
        expect(nock_1.default.isDone()).toBe(true);
    }));
    it("should preserve headers", () => __awaiter(void 0, void 0, void 0, function* () {
        // Arrange
        const client = axios_1.default.create();
        client.interceptors.request.use((0, _1.default)({ options: { region: "local" }, instance: axios_1.default }));
        const data = { foo: "bar" };
        const url = "https://localhost/foo";
        (0, nock_1.default)(url)
            .post("")
            .matchHeader("X-Custom-Header", "foo")
            .matchHeader("Content-Type", "application/json")
            .matchHeader("Authorization", /AWS/)
            .reply(200, {});
        // Act
        yield client.post(url, data, {
            headers: { "X-Custom-Header": "foo", "Content-Type": "application/json" },
        });
        // Assert
        expect(nock_1.default.isDone()).toBe(true);
    }));
    it("should preserve default headers - without interceptor", () => __awaiter(void 0, void 0, void 0, function* () {
        // Arrange
        const client = axios_1.default.create();
        const data = { foo: "bar" };
        const url = "https://localhost/foo";
        (0, nock_1.default)(url)
            .matchHeader("Content-Type", "application/json")
            .post("")
            .reply(200, {});
        // Act
        yield client.post(url, data, {});
        // Assert
        expect(nock_1.default.isDone()).toBe(true);
    }));
    it("should preserve default headers - with interceptor", () => __awaiter(void 0, void 0, void 0, function* () {
        // Arrange
        const client = axios_1.default.create();
        client.interceptors.request.use((0, _1.default)({ options: { region: "local" }, instance: axios_1.default }));
        const data = { foo: "bar" };
        const url = "https://localhost/foo";
        (0, nock_1.default)(url)
            .matchHeader("Content-Type", "application/json")
            .post("")
            .reply(200, {});
        // Act
        yield client.post(url, data, {});
        // Assert
        expect(nock_1.default.isDone()).toBe(true);
    }));
});
