"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeBE = exports.readBE = void 0;
const MAX_UINT32 = Math.pow(2, 32);
function readBE(buffer, offset) {
    offset = offset || 0;
    const hi = buffer.readUInt32BE(offset);
    const lo = buffer.readUInt32BE(offset + 4);
    return hi * MAX_UINT32 + lo;
}
exports.readBE = readBE;
function writeBE(buffer, value, offset) {
    offset = offset || 0;
    const hi = value / MAX_UINT32;
    const lo = value - hi * MAX_UINT32;
    buffer.writeUInt32BE(hi, offset);
    buffer.writeUInt32BE(lo, offset + 4);
    return offset + 8;
}
exports.writeBE = writeBE;
//# sourceMappingURL=uint64.js.map