"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Checksum = void 0;
const constants_1 = require("./constants");
/**
 * UDIF Checksum Structure
 */
class Checksum {
    constructor() {
        /** Checksum type (uint32) */
        this.type = constants_1.CHECKSUM_TYPE.NONE;
        /** Checksum size in bits (uint32) */
        this.bits = 0x00000000;
        /** Checksum as hex string */
        this.value = '';
    }
    /** Parse a UDIF checksum struct from a buffer */
    static parse(buffer, offset) {
        return new Checksum().parse(buffer, offset);
    }
    /** Parse a UDIF checksum structure from a buffer */
    parse(buffer, offset = 0) {
        this.type = buffer.readUInt32BE(offset + 0);
        this.bits = buffer.readUInt32BE(offset + 4);
        this.value = buffer.toString('hex', offset + 8, offset + 8 + this.bits / 8);
        return this;
    }
    /** Write a UDIF checksum structure to a buffer */
    write(buffer, offset = 0) {
        buffer = buffer || Buffer.alloc(Checksum.SIZE + offset);
        buffer.writeUInt32BE(this.type, offset + 0);
        buffer.writeUInt32BE(this.bits, offset + 4);
        buffer.write(this.value, offset + 8, this.bits / 8, 'hex');
        return buffer;
    }
}
exports.Checksum = Checksum;
/**
 * Checksum struct size in bytes
 * @todo verify correctness of this value
 */
Checksum.SIZE = 128;
//# sourceMappingURL=checksum.js.map