/// <reference types="node" />
import { BLOCK } from './constants';
/**
 * Mish Blkx Block Descriptor
 */
export declare class Block {
    /**
     * Size of the Mish Blkx Block Descriptor in bytes
     */
    static readonly SIZE = 40;
    /** Entry / compression type */
    type: number;
    /** Entry type name */
    description: string;
    /** Comment ('+beg'|'+end' if type == COMMENT) */
    comment: string;
    /** Start sector of this chunk */
    sectorNumber: number;
    /** Number of sectors in this chunk */
    sectorCount: number;
    /** Start of chunk in data fork */
    compressedOffset: number;
    /** Chunk's bytelength in data fork */
    compressedLength: number;
    /**
     * Get a human readable block type
     */
    static getDescription(type: BLOCK): string;
    /**
     * Parse Mish Block data from a buffer
     */
    static parse(buffer: Buffer, offset?: number): Block;
    /**
     * Parse Mish Block data from a buffer
     */
    parse(buffer: Buffer, offset?: number): this;
    /**
     * Write Mish Block data to a buffer
     */
    write(buffer: Buffer, offset?: number): Buffer;
}
