"use strict";
/* tslint:disable */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UDP = void 0;
const util_1 = require("./util");
const bp = require('binary-parser-encoder'); // Binary parser module
const sp = require('schemapack');
const Parser = bp.Parser;
// UDP Packet for encoding
const udp_e = sp.build([
    { udpSrc: 'uint16' },
    { udpDst: 'uint16' },
    { udpLen: 'uint16' },
    { chkSum: 'uint16' },
    { pad: 'string' },
]);
class UDP {
    parseUdp(buff) {
        // UDP packet
        const udp = new Parser()
            .uint16be('udpSrc')
            .uint16be('udpDest')
            .uint16be('udpLen')
            .uint16be('chkSum');
        return udp.parse(buff);
    }
    // Function for UDP packet
    makeUDP(udpDataLen, srcPort, dstPort) {
        const udp = [
            { udpSrc: srcPort },
            { udpDst: dstPort },
            { udpLen: udpDataLen + 8 },
            { chkSum: 0 },
        ];
        return (0, util_1.fixBuff)(udp_e.encode(udp));
    }
}
exports.UDP = UDP;
//# sourceMappingURL=udp.js.map