/**
 * @license
 * Copyright 2019 Balena Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/// <reference types="node" />
import { Readable } from 'stream';
import { BlockMap } from './blockmap';
import { ReadRange } from './read-range';
export declare type ReadFunction = (buffer: Buffer, offset: number, length: number, position: number) => Promise<{
    bytesRead: number;
    buffer: Buffer;
}>;
export declare class ReadStream extends Readable {
    readonly blockMap: BlockMap;
    readonly verify: boolean;
    readonly generateChecksums: boolean;
    readonly start: number;
    readonly end: number;
    readonly chunkSize: number;
    /** Range being currently processed */
    currentRange?: ReadRange;
    /** Number of block map ranges read */
    rangesRead: number;
    /** Number of block map ranges verified */
    rangesVerified: number;
    /** Number of blocks read */
    blocksRead: number;
    /** Number of bytes read */
    bytesRead: number;
    /** Current offset in bytes */
    position: number;
    /** Hash stream to calculate range checksums */
    private _hash?;
    /** Ranges to be read from the image */
    ranges: ReadRange[];
    private readFn;
    constructor(fdOrReadFn: number | ReadFunction, blockMap: BlockMap, verify?: boolean, generateChecksums?: boolean, start?: number, end?: number, chunkSize?: number);
    /**
     * Preprocess the `blockMap`'s ranges into byte-ranges
     * with respect to the `start` offset, and an `offset`
     * for tracking chunked range reading
     */
    private _prepareRanges;
    /**
     * Verify a fully read range's checksum against
     * the range's checksum from the blockmap
     */
    private _verifyRange;
    /**
     * Read the current range (or a chunk thereof),
     * update state and emit the read block
     */
    private _readBlock;
    /**
     * Advance to next the Range if there is one then read a block;
     * else end the stream;
     * @see https://nodejs.org/api/stream.html#stream_implementing_a_readable_stream
     */
    private _advanceRange;
    /**
     * Initiate a new read, advancing the range if necessary,
     * and verifying checksums, if enabled
     * @see https://nodejs.org/api/stream.html#stream_implementing_a_readable_stream
     */
    _read(): Promise<void>;
}
