/**
 * @license
 * Copyright 2019 Balena Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { Range } from './range';
export declare class ReadRange {
    range: Range;
    /** @type {String} Range checksum */
    checksum?: string;
    /** Range start offset in bytes */
    start: number;
    /** Range end offset in bytes */
    end: number;
    /** Range length in bytes */
    length: number;
    /** Range start LBA */
    startLBA: number;
    /** Range end LBA */
    endLBA: number;
    /** Byte offset within range */
    offset: number;
    constructor(range: Range, blockSize: number);
}
export declare class ReadRangeError extends Error {
    readonly range: ReadRange;
    checksum?: string | undefined;
    constructor(message: string, range: ReadRange, checksum?: string | undefined);
}
