"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const axios_1 = require("axios");
const _1 = require(".");
describe("getAuthErrorMessage", () => {
    it("should return the message from the error", () => {
        // Arrange
        const message = "Fake envalid credentials error";
        const error = new axios_1.AxiosError("Fake envalid credentials error", undefined, undefined, undefined, {
            data: {
                message,
            },
            statusText: "Forbidden",
            status: 403,
            headers: {},
            config: { headers: new axios_1.AxiosHeaders() },
        });
        // Act
        const actual = (0, _1.getAuthErrorMessage)(error);
        // Assert
        expect(actual).toEqual(message);
    });
    it("should return undefined if no error is present", () => {
        // Arrange
        const error = new axios_1.AxiosError("Just some other error", undefined, undefined, undefined, {
            data: {},
            statusText: "OK",
            status: 200,
            headers: {},
            config: { headers: new axios_1.AxiosHeaders() },
        });
        // Act
        const actual = (0, _1.getAuthErrorMessage)(error);
        // Assert
        expect(actual).toBeUndefined();
    });
});
