/// <reference types="node" />
import { Interval } from './interval-intersection';
export declare abstract class DiskChunk {
    readonly start: number;
    readonly end: number;
    constructor(start: number, // position in file
    end: number);
    abstract slice(start: number, end: number): DiskChunk;
    abstract data(): Buffer;
    interval(): Interval;
    intersection(other: DiskChunk): Interval | null;
    intersects(other: DiskChunk): boolean;
    includedIn(other: DiskChunk): boolean;
    cut(other: DiskChunk): DiskChunk[];
}
export declare class BufferDiskChunk extends DiskChunk {
    private readonly buffer;
    constructor(buffer: Buffer, offset: number, copy?: boolean);
    data(): Buffer;
    slice(start: number, end: number): BufferDiskChunk;
}
export declare class DiscardDiskChunk extends DiskChunk {
    constructor(offset: number, length: number);
    data(): Buffer;
    slice(start: number, end: number): DiscardDiskChunk;
}
