"use strict";
/**
 * @license
 * Copyright 2019 Balena Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Range = void 0;
class Range {
    constructor(start = 0, end = 0, checksum) {
        this.start = start;
        this.end = end;
        this.checksum = checksum;
        // start and end are inclusive
    }
    /**
     * Create a BlockMap.Range from a given value
     */
    static from(value) {
        return new Range(value.start, value.end, value.checksum);
    }
    get length() {
        // NOTE: Because a blockmap's range ends are inclusive,
        // we need to add a block to the LBAs here
        return this.end - this.start + 1;
    }
    set length(value) {
        // NOTE: Because a blockmap's range ends are inclusive,
        // we need to remove a block from the end here
        this.end = this.start + value - 1;
    }
}
exports.Range = Range;
//# sourceMappingURL=range.js.map