/**
 * @license
 * Copyright 2019 Balena Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { BlockMapOptionsRange } from './blockmap';
export declare class Range {
    start: number;
    end: number;
    checksum?: string | undefined;
    constructor(start?: number, end?: number, checksum?: string | undefined);
    /**
     * Create a BlockMap.Range from a given value
     */
    static from(value: BlockMapOptionsRange): Range;
    get length(): number;
    set length(value: number);
}
