/// <reference types="node" />
import { Context } from './context';
interface ParserOptions {
    length?: number | string | ((item: any) => number);
    assert?: number | string | ((item: number | string) => boolean);
    lengthInBytes?: number | string | ((item: any) => number);
    type?: string | Parser;
    formatter?: (item: any) => string | number;
    encoder?: (item: any) => any;
    encoding?: string;
    readUntil?: 'eof' | ((item: any, buffer: any) => number);
    encodeUntil?: 'eof' | ((item: any, buffer: any) => number);
    greedy?: boolean;
    choices?: {
        [key: number]: string | Parser;
    };
    defaultChoice?: string | Parser;
    zeroTerminated?: boolean;
    clone?: boolean;
    stripNull?: boolean;
    trim?: boolean;
    padding?: string;
    padd?: string;
    key?: string;
    tag?: string;
    offset?: number | string | ((item: any) => number);
}
interface EncoderOptions {
    bitEndianess?: boolean;
}
declare type Types = PrimitiveTypes | ComplexTypes;
declare type ComplexTypes = 'bit' | 'string' | 'buffer' | 'array' | 'choice' | 'nest' | 'seek' | 'pointer' | 'saveOffset' | '';
declare type Endianess = 'be' | 'le';
declare type PrimitiveTypes = 'uint8' | 'uint16le' | 'uint16be' | 'uint32le' | 'uint32be' | 'uint64le' | 'uint64be' | 'int8' | 'int16le' | 'int16be' | 'int32le' | 'int32be' | 'int64le' | 'int64be' | 'floatle' | 'floatbe' | 'doublele' | 'doublebe';
export declare class Parser {
    varName: string;
    type: Types;
    options: ParserOptions;
    next: Parser | null;
    head: Parser | null;
    compiled: Function | null;
    compiledEncode: Function | null;
    endian: Endianess;
    constructorFn: Function | null;
    alias: string | null;
    smartBufferSize: number;
    encoderOpts: EncoderOptions;
    constructor(opts?: any);
    static start(opts?: any): Parser;
    private primitiveGenerateN;
    private primitiveGenerate_encodeN;
    private primitiveN;
    private useThisEndian;
    uint8(varName: string, options?: ParserOptions): this;
    uint16(varName: string, options?: ParserOptions): this;
    uint16le(varName: string, options?: ParserOptions): this;
    uint16be(varName: string, options?: ParserOptions): this;
    uint32(varName: string, options?: ParserOptions): this;
    uint32le(varName: string, options?: ParserOptions): this;
    uint32be(varName: string, options?: ParserOptions): this;
    int8(varName: string, options?: ParserOptions): this;
    int16(varName: string, options?: ParserOptions): this;
    int16le(varName: string, options?: ParserOptions): this;
    int16be(varName: string, options?: ParserOptions): this;
    int32(varName: string, options?: ParserOptions): this;
    int32le(varName: string, options?: ParserOptions): this;
    int32be(varName: string, options?: ParserOptions): this;
    private bigIntVersionCheck;
    int64(varName: string, options?: ParserOptions): this;
    int64be(varName: string, options?: ParserOptions): this;
    int64le(varName: string, options?: ParserOptions): this;
    uint64(varName: string, options?: ParserOptions): this;
    uint64be(varName: string, options?: ParserOptions): this;
    uint64le(varName: string, options?: ParserOptions): this;
    floatle(varName: string, options?: ParserOptions): this;
    floatbe(varName: string, options?: ParserOptions): this;
    doublele(varName: string, options?: ParserOptions): this;
    doublebe(varName: string, options?: ParserOptions): this;
    private bitN;
    bit1(varName: string, options?: ParserOptions): this;
    bit2(varName: string, options?: ParserOptions): this;
    bit3(varName: string, options?: ParserOptions): this;
    bit4(varName: string, options?: ParserOptions): this;
    bit5(varName: string, options?: ParserOptions): this;
    bit6(varName: string, options?: ParserOptions): this;
    bit7(varName: string, options?: ParserOptions): this;
    bit8(varName: string, options?: ParserOptions): this;
    bit9(varName: string, options?: ParserOptions): this;
    bit10(varName: string, options?: ParserOptions): this;
    bit11(varName: string, options?: ParserOptions): this;
    bit12(varName: string, options?: ParserOptions): this;
    bit13(varName: string, options?: ParserOptions): this;
    bit14(varName: string, options?: ParserOptions): this;
    bit15(varName: string, options?: ParserOptions): this;
    bit16(varName: string, options?: ParserOptions): this;
    bit17(varName: string, options?: ParserOptions): this;
    bit18(varName: string, options?: ParserOptions): this;
    bit19(varName: string, options?: ParserOptions): this;
    bit20(varName: string, options?: ParserOptions): this;
    bit21(varName: string, options?: ParserOptions): this;
    bit22(varName: string, options?: ParserOptions): this;
    bit23(varName: string, options?: ParserOptions): this;
    bit24(varName: string, options?: ParserOptions): this;
    bit25(varName: string, options?: ParserOptions): this;
    bit26(varName: string, options?: ParserOptions): this;
    bit27(varName: string, options?: ParserOptions): this;
    bit28(varName: string, options?: ParserOptions): this;
    bit29(varName: string, options?: ParserOptions): this;
    bit30(varName: string, options?: ParserOptions): this;
    bit31(varName: string, options?: ParserOptions): this;
    bit32(varName: string, options?: ParserOptions): this;
    namely(alias: string): this;
    skip(length: number, options?: ParserOptions): this;
    seek(relOffset: number | ((item: any) => number), options?: ParserOptions): this;
    string(varName: string, options: ParserOptions): this;
    buffer(varName: string, options: ParserOptions): this;
    array(varName: string, options: ParserOptions): this;
    choice(varName: string | ParserOptions, options?: ParserOptions): this;
    nest(varName: string | ParserOptions, options: ParserOptions): this;
    pointer(varName: string, options?: ParserOptions): this;
    saveOffset(varName: string, options?: ParserOptions): this;
    endianess(endianess: 'little' | 'big'): this;
    encoderSetOptions(opts: EncoderOptions): this;
    create(constructorFn: Function): this;
    private getContext;
    getCode(): string;
    private getContextEncode;
    getCodeEncode(): string;
    private addRawCode;
    private addRawCodeEncode;
    private addAliasedCode;
    private addAliasedCodeEncode;
    private resolveReferences;
    compile(): void;
    compileEncode(): void;
    sizeOf(): number;
    parse(buffer: Buffer | Uint8Array): any;
    encode(obj: any): any;
    private setNextParser;
    private generate;
    generateEncode(ctx: Context): Context;
    private generateAssert;
    private generateNext;
    private generateEncodeNext;
    private generateBit;
    private generate_encodeBit;
    private generateSeek;
    private generate_encodeSeek;
    private generateString;
    private generate_encodeString;
    private generateBuffer;
    private generate_encodeBuffer;
    private generateArray;
    private generate_encodeArray;
    private generateChoiceCase;
    private generate_encodeChoiceCase;
    private generateChoice;
    private generate_encodeChoice;
    private generateNest;
    private generate_encodeNest;
    private generateFormatter;
    private generateEncoder;
    private generatePointer;
    private generate_encodePointer;
    private generateSaveOffset;
    private generate_encodeSaveOffset;
}
export {};
//# sourceMappingURL=binary_parser.d.ts.map