/// <reference types="node" />
import { CHECKSUM_TYPE } from './constants';
/**
 * UDIF Checksum Structure
 */
export declare class Checksum {
    /**
     * Checksum struct size in bytes
     * @todo verify correctness of this value
     */
    static readonly SIZE = 128;
    /** Checksum type (uint32) */
    type: CHECKSUM_TYPE;
    /** Checksum size in bits (uint32) */
    bits: number;
    /** Checksum as hex string */
    value: string;
    /** Parse a UDIF checksum struct from a buffer */
    static parse(buffer: Buffer, offset: number): Checksum;
    /** Parse a UDIF checksum structure from a buffer */
    parse(buffer: Buffer, offset?: number): this;
    /** Write a UDIF checksum structure to a buffer */
    write(buffer?: Buffer, offset?: number): Buffer;
}
