"use strict";
/* tslint:disable */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Eth = void 0;
const util_1 = require("./util");
const bp = require('binary-parser-encoder'); // Binary parser module
const sp = require('schemapack');
const Parser = bp.Parser;
// ether2 header for encoding
const ethhdr_e = sp.build([
    {
        h_dest: {
            0: 'uint8',
            1: 'uint8',
            2: 'uint8',
            3: 'uint8',
            4: 'uint8',
            5: 'uint8',
        },
    },
    {
        h_source: {
            0: 'uint8',
            1: 'uint8',
            2: 'uint8',
            3: 'uint8',
            4: 'uint8',
            5: 'uint8',
        },
    },
    { h_proto: 'uint16' },
    { pad: 'string' }, // Padding to shift extra bit to last for Schemapack
]);
class Eth {
    // ether header
    parseEthHdr(buff) {
        const ethhdr = new Parser()
            .array('h_dest', {
            type: 'uint8',
            length: 6,
        })
            .array('h_source', {
            type: 'uint8',
            length: 6,
        })
            .uint16be('h_proto');
        return ethhdr.parse(buff);
    }
    // Function for ether2 data packet
    makeEther2(dest, source, proto) {
        const eth = [{ h_dest: dest }, { h_source: source }, { h_proto: proto }];
        const data = (0, util_1.fixBuff)(ethhdr_e.encode(eth));
        return data;
    }
}
exports.Eth = Eth;
//# sourceMappingURL=eth.js.map