"use strict";
/* tslint:disable */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ARP = void 0;
const util_1 = require("./util");
const bp = require('binary-parser-encoder'); // Binary parser module
const Parser = bp.Parser;
const sp = require('schemapack');
// ARP header for response
const arphdr_e = sp.build([
    { htype: 'uint16' },
    { ptype: 'uint16' },
    { hlen: 'uint8' },
    { plen: 'uint8' },
    { opcode: 'uint16' },
    {
        hw_source: {
            0: 'uint8',
            1: 'uint8',
            2: 'uint8',
            3: 'uint8',
            4: 'uint8',
            5: 'uint8',
        },
    },
    { ip_source: { 0: 'uint8', 1: 'uint8', 2: 'uint8', 3: 'uint8' } },
    {
        hw_dest: {
            0: 'uint8',
            1: 'uint8',
            2: 'uint8',
            3: 'uint8',
            4: 'uint8',
            5: 'uint8',
        },
    },
    { ip_dest: { 0: 'uint8', 1: 'uint8', 2: 'uint8', 3: 'uint8' } },
    { pad: 'string' },
]);
class ARP {
    parseARP(buff) {
        const arphdr = new Parser()
            .uint16be('htype')
            .uint16be('ptype')
            .uint8('hlen')
            .uint8('plen')
            .uint16be('opcode')
            .array('hw_source', {
            length: 6,
            type: 'uint8',
        })
            .array('ip_source', {
            length: 4,
            type: 'uint8',
        })
            .array('hw_dest', {
            length: 6,
            type: 'uint8',
        })
            .array('ip_dest', {
            length: 4,
            type: 'uint8',
        });
        return arphdr.parse(buff);
    }
    // Function for ARP response
    makeARP(opcode, hw_source, ip_source, hw_dest, ip_dest) {
        const arp = [
            { htype: 1 },
            { ptype: 0x0800 },
            { hlen: 6 },
            { plen: 4 },
            { opcode: opcode },
            { hw_source: hw_source },
            { ip_source: ip_source },
            { hw_dest: hw_dest },
            { ip_dest: ip_dest },
        ];
        return (0, util_1.fixBuff)(arphdr_e.encode(arp));
    }
}
exports.ARP = ARP;
//# sourceMappingURL=arp.js.map